using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 2)
    {
      Console.WriteLine("Wywoanie programu: Program katalog wzorzec");
      return;
    }
    String katalog = args[0];
    String wzorzec = args[1];

    DirectoryInfo di = new DirectoryInfo(katalog);

    if(!di.Exists)
    {
      Console.WriteLine("Brak dostpu do katalogu: {0}", katalog);
      return;
    }

    DirectoryInfo[] katalogi;
    try
    {
      katalogi = di.GetDirectories(wzorzec);
    }
    catch(Exception)
    {
      Console.WriteLine("Wzorzec {0} jest niepoprawny.", wzorzec);
      return;
    }
    Console.WriteLine("Podkatalogi w katalogu {0} pasujce do wzorca {1}:",
      katalog, wzorzec);
    foreach(DirectoryInfo nazwa in katalogi){
      Console.WriteLine(nazwa.Name);
    }
  }
}
